﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Threading.Tasks;
    using Domain.Services;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Shared.EntityModels;
    using Shared.UserModels.Filters;
    using Utilities;

    /// <inheritdoc />
    /// <summary>
    /// The users controller.
    /// </summary>
    [Route("api/video-call-history")]
    [Authorize]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class VideoCallHistoryController : BaseController
    {
        /// <summary>
        /// The user service.
        /// </summary>
        private readonly IVideoCallHistoryService services;

        /// <inheritdoc />
        public VideoCallHistoryController(IVideoCallHistoryService services) => this.services = services;

        /// <summary>
        /// The fetch all.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Route("fetch-all")]
        public async Task<ActionResult> FetchAll([FromBody] VideoCallHistoryFilterModel model)
        {
            var response = await this.services.FetchAsync(model.AppointmentId);
            foreach (var item in response)
            {
                item.AppointmentTimeString = Convert.ToDateTime(DateTime.Now.ToString("yyyy-MM-dd")).Add(item.AppointmentTime).ToString("hh:mm tt");
            }

            return this.Success(response);
        }

        /// <summary>
        /// The fetch all.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Route("fetch")]
        public async Task<ActionResult> Fetch([FromBody] VideoCallHistoryFilterModel model)
        {
            var response = await this.services.FetchAsync(model.AppointmentId, model.DoctorDeviceDetailsId);
            return this.Success(response);
        }

        /// <summary>
        /// The insert.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        [HttpPost]
        [Route("create")]
        public async Task<ActionResult> Insert([FromBody] VideoCallHistoryModel model)
        {
            var response = await this.services.InsertAsync(model.AppointmentId);
            return this.Success(response);
        }
    }
}